/*
 * Decompiled with CFR 0.152.
 */
package fr.supelec.ese1010.signextension;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignExtension
extends InstanceFactory {
    private static final Attribute<BitWidth> width_in_attr = Attributes.forBitWidth((String)"Bit Width In");
    private static final Attribute<BitWidth> width_out_attr = Attributes.forBitWidth((String)"Bit Width Out");
    private static final Attribute<?>[] ATTRIBUTES = new Attribute[]{StdAttr.FACING, width_in_attr, width_out_attr};
    private static final Object[] DEFAULTS = new Object[]{Direction.EAST, BitWidth.ONE, BitWidth.ONE};
    private static final String LABEL = "(-)";
    private static final int[] shapeX = new int[]{14, 7, -14, -14, 7, 14};
    private static final int[] shapeY;
    private static final int[] iconX;
    private static final int[] iconY;

    static {
        int[] nArray = new int[6];
        nArray[1] = -7;
        nArray[2] = -7;
        nArray[3] = 7;
        nArray[4] = 7;
        shapeY = nArray;
        iconX = new int[]{2, 14, 18, 14, 2, 2};
        iconY = new int[]{3, 3, 9, 15, 15, 3};
    }

    public SignExtension() {
        super("Sign Extension");
        this.setAttributes(ATTRIBUTES, DEFAULTS);
        this.setFacingAttribute(StdAttr.FACING);
    }

    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    private void updatePorts(Instance instance) {
        Direction dir = (Direction)instance.getAttributeValue(StdAttr.FACING);
        BitWidth wIn = (BitWidth)instance.getAttributeValue(width_in_attr);
        BitWidth wOut = (BitWidth)instance.getAttributeValue(width_out_attr);
        Location loc0 = Location.create((int)0, (int)0);
        Location loc1 = loc0.translate(dir.reverse(), 30);
        Location loc2 = loc0.translate(dir.reverse(), 20, -10);
        instance.setPorts(new Port[]{new Port(loc0.getX(), loc0.getY(), "output", wOut.getWidth()), new Port(loc1.getX(), loc1.getY(), "input", wIn.getWidth()), new Port(loc2.getX(), loc2.getY(), "input", 1)});
    }

    public Bounds getOffsetBounds(AttributeSet attrs) {
        int w = 30;
        Direction facing = (Direction)attrs.getValue(StdAttr.FACING);
        if (facing == Direction.SOUTH) {
            return Bounds.create((int)-10, (int)(-w), (int)20, (int)w);
        }
        if (facing == Direction.WEST) {
            return Bounds.create((int)0, (int)-10, (int)w, (int)20);
        }
        if (facing == Direction.NORTH) {
            return Bounds.create((int)-10, (int)0, (int)20, (int)w);
        }
        return Bounds.create((int)(-w), (int)-10, (int)w, (int)20);
    }

    public void paintGhost(InstancePainter painter) {
        ((Graphics2D)painter.getGraphics()).setTransform(SignExtension.drawShape(painter));
    }

    public void paintIcon(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        g.setColor(Color.black);
        g.drawPolyline(iconX, iconY, iconX.length);
        g.setColor(Value.FALSE.getColor());
        g.drawLine(8, 15, 8, 18);
        g.setFont(g.getFont().deriveFont(9.0f));
        GraphicsUtil.drawCenteredText((Graphics)g, (String)LABEL, (int)9, (int)8);
    }

    public void propagate(InstanceState state) {
        if (state.getInstance().getPorts().size() != 3) {
            System.out.println("ports# = " + state.getInstance().getPorts().size());
            return;
        }
        Value control = state.getPort(2);
        Value in = state.getPort(1);
        int ow = state.getPort(0).getWidth();
        int iw = in.getWidth();
        if (in == Value.ERROR || control == Value.ERROR || ow < iw) {
            state.setPort(0, Value.ERROR, 0);
        } else if (in == Value.UNKNOWN || control == Value.UNKNOWN) {
            state.setPort(0, Value.UNKNOWN, 0);
        } else {
            Value out = in.extendWidth(ow, control == Value.TRUE ? in.get(iw - 1) : Value.FALSE);
            state.setPort(0, out, 0);
        }
    }

    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        } else if (attr == width_in_attr || attr == width_out_attr) {
            this.updatePorts(instance);
        }
    }

    public void paintInstance(InstancePainter painter) {
        AffineTransform origTransform = SignExtension.drawShape(painter);
        Graphics2D g = (Graphics2D)painter.getGraphics();
        if (painter.getInstance().getPorts().size() != 3) {
            g.setTransform(origTransform);
            return;
        }
        GraphicsUtil.switchToWidth((Graphics)g, (int)3);
        if (painter.getShowState()) {
            g.setColor(painter.getPort(2).getColor());
            g.drawLine(-5, 10, -5, 8);
        }
        g.setTransform(origTransform);
        if (!painter.isPrintView()) {
            painter.drawPort(0);
            painter.drawPort(1);
            painter.drawPort(2);
        }
    }

    private static AffineTransform drawShape(InstancePainter painter) {
        Direction facing = (Direction)painter.getAttributeValue(StdAttr.FACING);
        Graphics2D g = (Graphics2D)painter.getGraphics();
        AffineTransform origTransform = g.getTransform();
        Bounds bds = painter.getBounds();
        int x = bds.getX();
        int y = bds.getY();
        if (facing == Direction.EAST || facing == Direction.WEST) {
            g.translate(x + 15, y + 10);
        } else {
            g.translate(x + 10, y + 15);
        }
        if (facing != Direction.EAST) {
            g.rotate(-facing.toRadians());
        }
        GraphicsUtil.switchToWidth((Graphics)g, (int)2);
        g.drawPolyline(shapeX, shapeY, shapeX.length);
        g.setFont(g.getFont().deriveFont(11.0f));
        GraphicsUtil.drawCenteredText((Graphics)g, (String)LABEL, (int)-2, (int)-2);
        return origTransform;
    }
}

