/*
 * Decompiled with CFR 0.152.
 */
package fr.supelec.ese1010.registers;

import com.cburch.logisim.instance.InstanceData;
import fr.supelec.ese1010.registers.ClockState;

public class RegisterData
extends ClockState
implements InstanceData {
    private int[] values;
    private int size;
    private int error_int;
    private static final int ERROR_INT31 = -286331154;
    public static final int ERROR_VALUE = Integer.MIN_VALUE;

    public RegisterData(int size) {
        this.resize(size);
    }

    public RegisterData() {
        this(1);
    }

    public void resize(int newSize) {
        int[] oldValues = this.values;
        this.values = new int[newSize];
        if (oldValues != null) {
            System.arraycopy(oldValues, 0, this.values, 0, Math.min(this.size, newSize));
        }
        this.error_int = 0xEEEEEEEE | (1 << this.size) - 1;
        this.size = newSize;
    }

    public void setValue(int value) {
        this.setValue(0, value);
    }

    public void setValue(int index, int value) {
        this.values[index] = value == Integer.MIN_VALUE ? this.error_int : value;
    }

    public int getValue() {
        return this.getValue(0);
    }

    public int getValue(int index) {
        return this.values[index];
    }

    public int getSize() {
        return this.size;
    }
}

