/*
 * Decompiled with CFR 0.152.
 */
package fr.supelec.ese1010.controlunit;

import com.cburch.logisim.data.Value;
import fr.supelec.ese1010.controlunit.BinaryOperator;
import fr.supelec.ese1010.controlunit.EvaluationException;
import fr.supelec.ese1010.controlunit.OperatorAnd;
import fr.supelec.ese1010.controlunit.OperatorNot;
import fr.supelec.ese1010.controlunit.OperatorOr;
import fr.supelec.ese1010.controlunit.Variable;
import java.text.ParseException;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression {
    public abstract Value eval(Map<String, Value> var1) throws EvaluationException;

    private static int precedence(char op) {
        switch (op) {
            case '+': 
            case '|': {
                return 1;
            }
            case '&': 
            case '*': {
                return 2;
            }
            case '!': {
                return 3;
            }
        }
        return -1;
    }

    private static void pushVariable(Stack<Expression> output, String var) {
        output.push(new Variable(var));
    }

    private static void pushOperator(Stack<Expression> output, char op) throws ParseException {
        if (op == '|' || op == '&' || op == '+' || op == '*') {
            if (output.size() < 2) {
                throw new ParseException("Arity problem while processing binary operator " + op, 0);
            }
            Expression arg2 = output.pop();
            Expression arg1 = output.pop();
            BinaryOperator operator = null;
            switch (op) {
                case '+': 
                case '|': {
                    operator = new OperatorOr(arg1, arg2);
                    break;
                }
                case '&': 
                case '*': {
                    operator = new OperatorAnd(arg1, arg2);
                }
            }
            output.push(operator);
        } else if (op == '!') {
            if (output.empty()) {
                throw new ParseException("Arity problem while processing unary operator " + op, 0);
            }
            output.push(new OperatorNot(output.pop()));
        } else {
            throw new ParseException("Unknown operator:" + op, 0);
        }
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\u00a0' || c == '\t';
    }

    private static boolean hasOnlyWhiteSpace(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Expression.isWhiteSpace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Expression parse(String s) throws ParseException {
        Stack<Expression> output = new Stack<Expression>();
        Stack<Character> operator = new Stack<Character>();
        StringTokenizer st = new StringTokenizer(s, " \u00a0\t&|!()+*", true);
        block0: while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (Expression.hasOnlyWhiteSpace(t)) continue;
            if ("|".equals(t) || "&".equals(t) || "!".equals(t) || "+".equals(t) || "*".equals(t)) {
                char o1 = t.charAt(0);
                int po1 = Expression.precedence(o1);
                while (!operator.isEmpty()) {
                    char o2 = ((Character)operator.peek()).charValue();
                    int po2 = Expression.precedence(o2);
                    if (o1 != '|' && o1 != '&' && o1 != '+' && o1 != '*' || po1 > po2) break;
                    operator.pop();
                    Expression.pushOperator(output, o2);
                }
                operator.push(Character.valueOf(o1));
                continue;
            }
            if ("(".equals(t)) {
                operator.push(Character.valueOf('('));
                continue;
            }
            if (")".equals(t)) {
                while (true) {
                    if (operator.isEmpty()) {
                        throw new ParseException("Mismatched parentheses", 0);
                    }
                    char o = ((Character)operator.pop()).charValue();
                    if (o == '(') continue block0;
                    Expression.pushOperator(output, o);
                }
            }
            Expression.pushVariable(output, t);
        }
        while (!operator.isEmpty()) {
            char o = ((Character)operator.pop()).charValue();
            if (o == '(' || o == ')') {
                throw new ParseException("Mismatched parentheses", 0);
            }
            Expression.pushOperator(output, o);
        }
        if (output.size() != 1) {
            throw new ParseException("Malformed expression", 0);
        }
        return (Expression)output.pop();
    }
}

