/*
 * Decompiled with CFR 0.152.
 */
package fr.supelec.ese1010.controlunit;

import com.cburch.logisim.data.Value;
import fr.supelec.ese1010.controlunit.EvaluationException;
import fr.supelec.ese1010.controlunit.Expression;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Equations {
    private final String text;
    public String errorMsgShort;
    public String errorMsgLong;
    private List<String> inputNames;
    private Map<String, Expression> internals;
    private List<String> outputNames;
    private Map<String, Expression> outputs;
    private Map<String, Value> internalSignalValues = null;
    private boolean parseOK;
    public static Equations DEFAULT_VALUE = new Equations("# Write equations here\n");

    public Equations(String s) {
        this.text = s;
        try {
            String l;
            BufferedReader br = new BufferedReader(new StringReader(this.text));
            this.inputNames = new LinkedList<String>();
            this.internals = new LinkedHashMap<String, Expression>();
            this.outputNames = new LinkedList<String>();
            this.outputs = new HashMap<String, Expression>();
            this.parseOK = false;
            while ((l = br.readLine()) != null) {
                if ("".equals(l = l.split("#")[0].trim())) continue;
                try {
                    String name;
                    String[] parts = l.split("\\s+", 2);
                    if (parts.length != 2) {
                        throw new ParseException("Unrecognized line: " + l, 0);
                    }
                    String[] eqp = parts[1].trim().split("=", 2);
                    int i = 0;
                    while (i < eqp.length) {
                        eqp[i] = eqp[i].trim();
                        ++i;
                    }
                    String lineType = parts[0].trim();
                    if ("input".equals(lineType)) {
                        this.inputNames.add(parts[1]);
                        continue;
                    }
                    if ("internal".equals(lineType)) {
                        if (eqp.length != 2) {
                            throw new ParseException("Missing equal sign: " + l, 0);
                        }
                        name = eqp[0];
                        this.internals.put(name, Expression.parse(eqp[1]));
                        continue;
                    }
                    if ("output".equals(lineType)) {
                        if (eqp.length != 2) {
                            throw new ParseException("Missing equal sign: " + l, 0);
                        }
                        name = eqp[0];
                        this.outputs.put(name, Expression.parse(eqp[1]));
                        this.outputNames.add(name);
                        continue;
                    }
                    throw new ParseException("Unknown line type: '" + lineType + "'", 0);
                }
                catch (ParseException e) {
                    throw new ParseException("On line \"" + l + "\": " + e.getMessage(), 0);
                }
            }
            this.errorMsgLong = null;
            this.errorMsgShort = null;
            this.parseOK = true;
        }
        catch (IOException e) {
            this.errorMsgShort = "I/O";
            this.errorMsgLong = "Input/output error while reading file: " + e.getMessage();
        }
        catch (ParseException e) {
            this.errorMsgShort = "PARSE";
            this.errorMsgLong = "Syntax error in equations: " + e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Value[] eval(Value[] in, Map<String, Value> ini) {
        try {
            void var5_16;
            void var4_6;
            HashMap<String, Value> vals = new HashMap<String, Value>(ini);
            vals.put("0", Value.FALSE);
            vals.put("1", Value.TRUE);
            boolean bl = false;
            while (var4_6 < this.inputNames.size()) {
                vals.put(this.inputNames.get((int)var4_6), in[var4_6]);
                ++var4_6;
            }
            Equations equations = this;
            synchronized (equations) {
                this.internalSignalValues = new LinkedHashMap<String, Value>();
                for (Map.Entry<String, Expression> entry : this.internals.entrySet()) {
                    try {
                        String key = entry.getKey();
                        Value value = entry.getValue().eval(vals);
                        vals.put(key, value);
                        this.internalSignalValues.put(key, value);
                    }
                    catch (EvaluationException exc) {
                        throw new EvaluationException("In " + entry.getKey() + " = " + entry.getValue() + ": " + exc.getMessage());
                    }
                }
            }
            for (Map.Entry<String, Expression> entry : this.outputs.entrySet()) {
                try {
                    vals.put(entry.getKey(), entry.getValue().eval(vals));
                }
                catch (EvaluationException exc) {
                    throw new EvaluationException("In " + entry.getKey() + " = " + entry.getValue() + ": " + exc.getMessage());
                }
            }
            Value[] valueArray = new Value[this.outputNames.size()];
            boolean bl2 = false;
            while (var5_16 < valueArray.length) {
                valueArray[var5_16] = (Value)vals.get(this.outputNames.get((int)var5_16));
                ++var5_16;
            }
            this.errorMsgLong = null;
            this.errorMsgShort = null;
            return valueArray;
        }
        catch (EvaluationException e) {
            this.errorMsgShort = "EVAL";
            this.errorMsgLong = "Error while computing equations: " + e.getMessage();
            return null;
        }
    }

    public int getInputCount() {
        return this.inputNames.size();
    }

    public int getOutputCount() {
        return this.outputNames.size();
    }

    public String getInputName(int i) {
        return this.inputNames.get(i);
    }

    public String getOutputName(int i) {
        return this.outputNames.get(i);
    }

    public synchronized String getInternalSignalValues() {
        if (this.internalSignalValues == null) {
            return null;
        }
        if (this.internalSignalValues.size() == 0) {
            return "No internal signals.";
        }
        StringBuffer str = new StringBuffer("Internal signals:\n");
        for (Map.Entry<String, Value> e : this.internalSignalValues.entrySet()) {
            str.append("      ").append(e.getKey()).append(" = ").append(e.getValue()).append('\n');
        }
        return str.toString();
    }

    public synchronized Value getInternalSignalValue(String name, Value deflt) {
        if (this.internalSignalValues == null) {
            return deflt;
        }
        Value val = this.internalSignalValues.get(name);
        if (val == null) {
            return deflt;
        }
        return val;
    }

    public String getText() {
        return this.text;
    }

    public boolean valid() {
        return this.errorMsgShort == null;
    }

    public boolean parseOK() {
        return this.parseOK;
    }

    public String getShortError() {
        return this.errorMsgShort;
    }

    public String getLongError() {
        return this.errorMsgLong;
    }
}

