/*
 * Decompiled with CFR 0.152.
 */
package fr.supelec.ese1010.controlunit;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.tools.ToolTipMaker;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import fr.supelec.ese1010.Strings;
import fr.supelec.ese1010.controlunit.ControlUnitData;
import fr.supelec.ese1010.controlunit.ControlUnitMenu;
import fr.supelec.ese1010.controlunit.ControlUnitPoker;
import fr.supelec.ese1010.controlunit.ControlUnitToolTip;
import fr.supelec.ese1010.controlunit.Equations;
import fr.supelec.ese1010.controlunit.EquationsAttribute;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlUnit
extends InstanceFactory {
    public static final Attribute<Integer> cycle_length_attr = Attributes.forIntegerRange((String)"cycle_length", (StringGetter)Strings.getter("Cycle Length"), (int)1, (int)20);
    public static final Attribute<Equations> equations_attr = new EquationsAttribute("equation_file", Strings.getter("Equations"));
    private static final Attribute<StopPolicy> stop_policy_attr = Attributes.forOption((String)"stop_policy", (StringGetter)Strings.getter("Stop Policy"), (Object[])new StopPolicy[]{StopPolicy.STOP_BEFORE, StopPolicy.STOP_AFTER});
    static final Attribute<?>[] ATTRIBUTES = new Attribute[]{cycle_length_attr, equations_attr, stop_policy_attr};
    static final Object[] VALUES = new Object[]{5, Equations.DEFAULT_VALUE, StopPolicy.STOP_AFTER};

    public ControlUnit() {
        super("Control Unit");
        this.setAttributes(ATTRIBUTES, VALUES);
        this.setInstancePoker(ControlUnitPoker.class);
    }

    protected void configureNewInstance(Instance instance) {
        this.configureComponent(instance);
        instance.addAttributeListener();
    }

    private ControlUnitData getData(InstanceState state) {
        ControlUnitData data = (ControlUnitData)state.getData();
        if (data == null) {
            data = new ControlUnitData();
            state.setData((InstanceData)data);
        }
        StopPolicy policy = (StopPolicy)((Object)state.getAttributeValue(stop_policy_attr));
        policy.setStopTimes(state.getInstance(), data);
        return data;
    }

    protected ControlUnitData getData(Instance instance, CircuitState state) {
        ControlUnitData data = (ControlUnitData)instance.getData(state);
        if (data == null) {
            data = new ControlUnitData();
            instance.setData(state, (InstanceData)data);
        }
        StopPolicy policy = (StopPolicy)((Object)instance.getAttributeValue(stop_policy_attr));
        policy.setStopTimes(instance, data);
        return data;
    }

    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == equations_attr) {
            this.configureComponent(instance);
        }
    }

    private synchronized void configureComponent(Instance instance) {
        Equations equations = (Equations)instance.getAttributeValue(equations_attr);
        int nbIn = 0;
        int nbOut = 0;
        if (equations.parseOK()) {
            nbIn = equations.getInputCount();
            nbOut = equations.getOutputCount();
        }
        Port[] ports = new Port[nbIn + nbOut + 1];
        int i = 0;
        while (i < nbIn) {
            ports[i] = new Port(0, 60 + 10 * i, "input", 1);
            ++i;
        }
        int j = 0;
        while (j < nbOut) {
            ports[j + nbIn] = new Port(80, 60 + 10 * j, "output", 1);
            ++j;
        }
        ports[nbIn + nbOut] = new Port(40, 0, "input", 1);
        instance.setPorts(ports);
    }

    public synchronized void forceTStart(ControlUnitData data) {
        data.stopCond = ControlUnitData.StopCond.RESET;
    }

    protected Object getInstanceFeature(Instance instance, Object key) {
        if (key == MenuExtender.class) {
            return new ControlUnitMenu(this, instance);
        }
        if (key == ToolTipMaker.class) {
            return new ControlUnitToolTip(instance);
        }
        return super.getInstanceFeature(instance, key);
    }

    public void paintInstance(InstancePainter painter) {
        ControlUnitData data = this.getData((InstanceState)painter);
        Instance instance = painter.getInstance();
        Equations equations = (Equations)instance.getAttributeValue(equations_attr);
        String msg = equations.getShortError();
        Bounds bounds = this.getOffsetBounds(null);
        Graphics2D g = (Graphics2D)painter.getGraphics();
        AffineTransform origTransform = g.getTransform();
        Bounds bds = painter.getBounds();
        g.translate(bds.getX(), bds.getY());
        if (msg == null) {
            painter.drawRectangle(bounds, "Control Unit");
        } else {
            Color col = g.getColor();
            g.setColor(Color.RED);
            painter.drawRectangle(bounds, "Ctl #" + msg);
            g.setColor(col);
        }
        if (painter.getShowState()) {
            GraphicsUtil.drawCenteredText((Graphics)g, (String)("T" + (data.currentTime + 2) / 3), (int)(bounds.getX() + bounds.getWidth() / 2), (int)(bounds.getY() + 20));
            if (data.currentTime % 3 == 2) {
                GraphicsUtil.drawCenteredText((Graphics)g, (String)("P" + (data.currentTime + 2) / 3), (int)(bounds.getX() + bounds.getWidth() / 2), (int)(bounds.getY() + 35));
            }
            int x = bounds.getX();
            int top = bounds.getY() + bounds.getHeight() - 14;
            int w = bounds.getWidth();
            int buttonW = w / ControlUnitData.StopCond.buttons.length;
            ControlUnitData.StopCond[] stopCondArray = ControlUnitData.StopCond.buttons;
            int n = ControlUnitData.StopCond.buttons.length;
            int n2 = 0;
            while (n2 < n) {
                ControlUnitData.StopCond s = stopCondArray[n2];
                painter.drawRectangle(x + buttonW * s.index, top, buttonW, 14, s.buttonLetter);
                ++n2;
            }
            if (data.stopCond.index >= 0) {
                Color stdCol = g.getColor();
                g.setColor(Color.RED);
                painter.drawRectangle(x + buttonW * data.stopCond.index, top, buttonW, 14, data.stopCond.buttonLetter);
                g.setColor(stdCol);
            }
        }
        g.setTransform(origTransform);
        int nbIn = 0;
        int nbOut = 0;
        if (equations.parseOK()) {
            nbIn = equations.getInputCount();
            nbOut = equations.getOutputCount();
            int i = 0;
            while (i < nbIn) {
                painter.drawPort(i, equations.getInputName(i), Direction.EAST);
                ++i;
            }
            i = 0;
            while (i < nbOut) {
                painter.drawPort(nbIn + i, equations.getOutputName(i), Direction.WEST);
                ++i;
            }
        }
        painter.drawClock(nbIn + nbOut, Direction.SOUTH);
    }

    public synchronized void propagate(InstanceState state) {
        Equations equations = (Equations)state.getAttributeValue(equations_attr);
        if (!equations.parseOK()) {
            return;
        }
        int nbIn = equations.getInputCount();
        int nbOut = equations.getOutputCount();
        boolean outChanged = false;
        Value[] in = new Value[nbIn];
        int i = 0;
        while (i < nbIn) {
            in[i] = state.getPort(i);
            ++i;
        }
        Value inH = state.getPort(nbIn + nbOut);
        Value[] out = new Value[nbOut];
        int lgrCycle = (Integer)state.getAttributeValue(cycle_length_attr);
        ControlUnitData data = this.getData(state);
        if (data.stopCond == ControlUnitData.StopCond.RESET) {
            data.currentTime = (data.stopTimeInCycle - 1) * 3 + 1 + data.stopStepInTime;
        }
        if (inH.isErrorValue()) {
            int i2 = 0;
            while (i2 < equations.getOutputCount()) {
                out[i2] = Value.ERROR;
                ++i2;
            }
            outChanged = true;
        } else {
            int currentTime = data.currentTime;
            if (inH.isFullyDefined() && !inH.equals((Object)data.lastClock) && data.stopCond != ControlUnitData.StopCond.STOP || data.stopCond == ControlUnitData.StopCond.FORCE || data.stopCond == ControlUnitData.StopCond.RESET) {
                if (data.stopCond != ControlUnitData.StopCond.FORCE && data.stopCond != ControlUnitData.StopCond.RESET) {
                    if (data.stopCond == ControlUnitData.StopCond.STEP) {
                        data.stopCond = ControlUnitData.StopCond.STOP;
                    }
                    if (++currentTime > lgrCycle * 3) {
                        currentTime = 1;
                    }
                    if (data.stopCond == ControlUnitData.StopCond.CYCLE && (currentTime + 2) / 3 == data.stopTimeInCycle && (currentTime - 1) % 3 == data.stopStepInTime) {
                        data.stopCond = ControlUnitData.StopCond.STOP;
                    }
                    if (data.stopCond == ControlUnitData.StopCond.TIME && (currentTime - 1) % 3 == data.stopStepInTime) {
                        data.stopCond = ControlUnitData.StopCond.STOP;
                    }
                    data.currentTime = currentTime;
                } else {
                    data.stopCond = ControlUnitData.StopCond.STOP;
                }
            }
            Value[] T = new Value[lgrCycle];
            Value[] P = new Value[lgrCycle];
            int i3 = 0;
            while (i3 < lgrCycle) {
                T[i3] = Value.FALSE;
                P[i3] = Value.FALSE;
                ++i3;
            }
            int temps = (currentTime - 1) / 3;
            if (temps < lgrCycle) {
                T[temps] = Value.TRUE;
                if ((currentTime - 1) % 3 == 1) {
                    P[temps] = Value.TRUE;
                }
            }
            HashMap<String, Value> tipi = new HashMap<String, Value>();
            int i4 = 0;
            while (i4 < lgrCycle) {
                tipi.put("T" + (i4 + 1), T[i4]);
                tipi.put("P" + (i4 + 1), P[i4]);
                ++i4;
            }
            Value[] eval = equations.eval(in, tipi);
            if (eval != null) {
                out = eval;
            }
            if (data.stopCond == ControlUnitData.StopCond.AUTO && equations.getInternalSignalValue("STOP", Value.TRUE) == Value.FALSE) {
                data.stopCond = ControlUnitData.StopCond.TIME;
            }
            outChanged = true;
        }
        if (equations != null && outChanged) {
            int j = 0;
            while (j < out.length) {
                state.setPort(nbIn + j, out[j], 0);
                ++j;
            }
        }
        data.lastClock = inH;
    }

    public Bounds getOffsetBounds(AttributeSet attrs) {
        int max = 20;
        return Bounds.create((int)0, (int)0, (int)80, (int)(80 + 10 * (max - 1) + 20));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StopPolicy {
        STOP_BEFORE{

            public void setStopTimes(Instance i, ControlUnitData s) {
                s.stopTimeInCycle = 1;
                s.stopStepInTime = 0;
            }

            public String toString() {
                return "Beginning of time/cycle";
            }
        }
        ,
        STOP_AFTER{

            public void setStopTimes(Instance i, ControlUnitData s) {
                s.stopTimeInCycle = (Integer)i.getAttributeValue(cycle_length_attr);
                s.stopStepInTime = 2;
            }

            public String toString() {
                return "End of time/cycle";
            }
        };


        public abstract void setStopTimes(Instance var1, ControlUnitData var2);
    }
}

