/*
 * Decompiled with CFR 0.152.
 */
package fr.supelec.ese1010.alu;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class ALU
extends InstanceFactory {
    private static final BitWidth WIDTH_DEFAULT = BitWidth.create((int)8);
    private static final String[] opNames = new String[]{"(A)", "(A|B)", "!(A|B)", "!(A&B)", "(A&B)", "(B)", "(!B)", "(A^B)", "(A-B)", "(A+B)", "(A+A)", "(A-1)", "(A+1)", "(FFFF)", "(0)", "(!A)"};
    private static final boolean[] needsA;
    private static final boolean[] needsB;
    private static final String[] pinNames;
    private static final Direction[] pinNameDirs;
    private static final int[] iconX;
    private static final int[] iconY;
    private static final int[] symbolX;
    private static final int[] symbolY;

    static {
        boolean[] blArray = new boolean[16];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[15] = true;
        needsA = blArray;
        boolean[] blArray2 = new boolean[16];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        needsB = blArray2;
        pinNames = new String[]{"A   ", "   B", " U0", " U1", " U2", " U3", "   S", "N ", "Z ", "C ", "V "};
        pinNameDirs = new Direction[]{Direction.SOUTH, Direction.SOUTH, Direction.EAST, Direction.EAST, Direction.EAST, Direction.EAST, Direction.NORTH, Direction.WEST, Direction.WEST, Direction.WEST, Direction.WEST};
        iconX = new int[]{3, 10, 12, 14, 21, 17, 7};
        iconY = new int[]{2, 2, 8, 2, 2, 15, 15};
        int[] nArray = new int[7];
        nArray[0] = -140;
        nArray[1] = -90;
        nArray[2] = -70;
        nArray[3] = -50;
        nArray[5] = -50;
        nArray[6] = -90;
        symbolX = nArray;
        int[] nArray2 = new int[7];
        nArray2[0] = -20;
        nArray2[1] = -20;
        nArray2[3] = -20;
        nArray2[4] = -20;
        nArray2[5] = 30;
        nArray2[6] = 30;
        symbolY = nArray2;
    }

    public ALU() {
        super("ALU");
        this.setAttributes(new Attribute[]{StdAttr.WIDTH}, new Object[]{WIDTH_DEFAULT});
        this.setOffsetBounds(Bounds.create((int)-140, (int)-20, (int)140, (int)50));
        this.setPorts(new Port[]{new Port(-110, -20, "input", StdAttr.WIDTH), new Port(-30, -20, "input", StdAttr.WIDTH), new Port(-130, -10, "input", 1), new Port(-120, 0, "input", 1), new Port(-110, 10, "input", 1), new Port(-100, 20, "input", 1), new Port(-70, 30, "output", StdAttr.WIDTH), new Port(-10, -10, "output", 1), new Port(-20, 0, "output", 1), new Port(-30, 10, "output", 1), new Port(-40, 20, "output", 1)});
    }

    public void propagate(InstanceState state) {
        Value outV;
        Value outC;
        Value outZ;
        Value outN;
        Value outS;
        Value inA = state.getPort(0);
        Value inB = state.getPort(1);
        Value inU0 = state.getPort(2);
        Value inU1 = state.getPort(3);
        Value inU2 = state.getPort(4);
        Value inU3 = state.getPort(5);
        if (inU0.isFullyDefined() && inU1.isFullyDefined() && inU2.isFullyDefined() && inU3.isFullyDefined()) {
            BitWidth width = inA.getBitWidth();
            int wdInt = width.getWidth();
            int BIT_U0 = inU0.toIntValue();
            int BIT_U1 = inU1.toIntValue();
            int BIT_U2 = inU2.toIntValue();
            int BIT_U3 = inU3.toIntValue();
            int command = 8 * BIT_U3 + 4 * BIT_U2 + 2 * BIT_U1 + BIT_U0;
            if (needsA[command] && !inA.isFullyDefined() || needsB[command] && !inB.isFullyDefined()) {
                if (needsA[command] && inA.isErrorValue() || needsB[command] && inB.isErrorValue()) {
                    outS = Value.createError((BitWidth)width);
                    outN = Value.ERROR;
                    outZ = Value.ERROR;
                    outC = Value.ERROR;
                    outV = Value.ERROR;
                } else {
                    outS = Value.createUnknown((BitWidth)width);
                    outN = Value.UNKNOWN;
                    outZ = Value.UNKNOWN;
                    outC = Value.UNKNOWN;
                    outV = Value.UNKNOWN;
                }
            } else {
                int out;
                int VAL_A = inA.toIntValue();
                int VAL_B = inB.toIntValue();
                int ALL_ONES = Value.createKnown((BitWidth)width, (int)0).not().toIntValue();
                int N_VAL_A = inA.not().toIntValue();
                int N_VAL_B = inB.not().toIntValue();
                switch (command) {
                    case 0: {
                        out = VAL_A;
                        break;
                    }
                    case 1: {
                        out = VAL_A | VAL_B;
                        break;
                    }
                    case 2: {
                        out = ALL_ONES ^ (VAL_A | VAL_B);
                        break;
                    }
                    case 3: {
                        out = ALL_ONES ^ VAL_A & VAL_B;
                        break;
                    }
                    case 4: {
                        out = VAL_A & VAL_B;
                        break;
                    }
                    case 5: {
                        out = VAL_B;
                        break;
                    }
                    case 6: {
                        out = N_VAL_B;
                        break;
                    }
                    case 7: {
                        out = VAL_A ^ VAL_B;
                        break;
                    }
                    case 8: {
                        out = VAL_A - VAL_B;
                        break;
                    }
                    case 9: {
                        out = VAL_A + VAL_B;
                        break;
                    }
                    case 10: {
                        out = VAL_A + VAL_A;
                        break;
                    }
                    case 11: {
                        out = VAL_A - 1;
                        break;
                    }
                    case 12: {
                        out = VAL_A + 1;
                        break;
                    }
                    case 13: {
                        out = ALL_ONES;
                        break;
                    }
                    case 14: {
                        out = 0;
                        break;
                    }
                    case 15: {
                        out = N_VAL_A;
                        break;
                    }
                    default: {
                        out = 0;
                    }
                }
                outS = Value.createKnown((BitWidth)width, (int)out);
                outN = outS.get(wdInt - 1);
                outZ = outS.toIntValue() == 0 ? Value.TRUE : Value.FALSE;
                outC = (out >> wdInt & 1) == 1 ? Value.TRUE : Value.FALSE;
                outV = inA.get(wdInt - 1) == inA.get(wdInt - 1) && outS.get(wdInt - 1) != inA.get(wdInt - 1) ? Value.TRUE : Value.FALSE;
            }
        } else if (inU0.isErrorValue() || inU1.isErrorValue() || inU2.isErrorValue() || inU3.isErrorValue()) {
            outS = Value.createError((BitWidth)inA.getBitWidth());
            outC = outV = Value.createError((BitWidth)inA.getBitWidth());
            outZ = outV;
            outN = outV;
        } else {
            outS = Value.createUnknown((BitWidth)inA.getBitWidth());
            outC = outV = Value.createUnknown((BitWidth)inA.getBitWidth());
            outZ = outV;
            outN = outV;
        }
        state.setPort(6, outS, 1);
        state.setPort(7, outN, 1);
        state.setPort(8, outZ, 1);
        state.setPort(9, outC, 1);
        state.setPort(10, outV, 1);
    }

    public void paintInstance(InstancePainter painter) {
        int i = 0;
        while (i < pinNames.length) {
            painter.drawPort(i, pinNames[i], pinNameDirs[i]);
            ++i;
        }
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        int x = bds.getX();
        int y = bds.getY();
        g.translate(x + 140, y + 20);
        GraphicsUtil.switchToWidth((Graphics)g, (int)2);
        g.drawPolygon(symbolX, symbolY, symbolX.length);
        Value inU0 = painter.getPort(2);
        Value inU1 = painter.getPort(3);
        Value inU2 = painter.getPort(4);
        Value inU3 = painter.getPort(5);
        if (painter.getShowState() && inU0.isFullyDefined() && inU1.isFullyDefined() && inU2.isFullyDefined() && inU3.isFullyDefined()) {
            int BIT_U0 = inU0.toIntValue();
            int BIT_U1 = inU1.toIntValue();
            int BIT_U2 = inU2.toIntValue();
            int BIT_U3 = inU3.toIntValue();
            int command = 8 * BIT_U3 + 4 * BIT_U2 + 2 * BIT_U1 + BIT_U0;
            GraphicsUtil.drawCenteredText((Graphics)g, (String)opNames[command], (int)(bds.getWidth() / 2 - 140), (int)(bds.getHeight() / 2 - 20));
        }
    }

    public void paintIcon(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        g.setColor(Color.BLACK);
        g.drawPolygon(iconX, iconY, iconX.length);
    }

    public void paintGhost(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth((Graphics)g, (int)2);
        g.drawPolygon(symbolX, symbolY, symbolX.length);
    }
}

