/*
 * Decompiled with CFR 0.152.
 */
package fr.supelec.ese1010.registers;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import fr.supelec.ese1010.registers.RegisterData;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class RegisterPoker
extends InstancePoker {
    private int initValue;
    private int curValue;

    public boolean init(InstanceState state, MouseEvent e) {
        RegisterData data = (RegisterData)state.getData();
        if (data == null) {
            data = new RegisterData();
            state.setData((InstanceData)data);
        }
        this.curValue = this.initValue = data.getValue();
        return true;
    }

    public void paint(InstancePainter painter) {
        Bounds bds = painter.getBounds();
        BitWidth dataWidth = (BitWidth)painter.getAttributeValue(StdAttr.WIDTH);
        int width = dataWidth == null ? 8 : dataWidth.getWidth();
        int len = (width + 3) / 4;
        Graphics g = painter.getGraphics();
        g.setColor(Color.RED);
        if (len > 4) {
            g.drawRect(bds.getX(), bds.getY() + 3, bds.getWidth(), 25);
        } else {
            int wid = 7 * len + 2;
            g.drawRect(bds.getX() + (bds.getWidth() - wid) / 2, bds.getY() + 4, wid, 15);
        }
        g.setColor(Color.BLACK);
    }

    public void keyTyped(InstanceState state, KeyEvent e) {
        int val = Character.digit(e.getKeyChar(), 16);
        if (val < 0) {
            return;
        }
        BitWidth dataWidth = (BitWidth)state.getAttributeValue(StdAttr.WIDTH);
        if (dataWidth == null) {
            dataWidth = BitWidth.create((int)8);
        }
        this.curValue = this.curValue * 16 + val & dataWidth.getMask();
        RegisterData data = (RegisterData)state.getData();
        data.setValue(this.curValue);
        state.fireInvalidated();
    }
}

