/*
 * Decompiled with CFR 0.152.
 */
package fr.supelec.ese1010.registers;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import fr.supelec.ese1010.registers.RegisterData;
import java.awt.Color;
import java.awt.Graphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterFile
extends InstanceFactory {
    private static final int PORT_IN = 0;
    private static final int[] PORT_OUT = new int[]{1, 2};
    private static final int PORT_CLOCK = 3;
    private static final int PORT_IS = 4;
    private static final int[] PORT_OS = new int[]{5, 6};
    private static final int[] PORT_ON = new int[]{7, 8};
    private static final int[] PORT_OZ = new int[]{9, 10};
    private static final int PORT_RST = 11;
    private static final int DELAY = 8;
    private static final int LINE_HEIGHT = 11;
    private static final Color COLOR_IN = Color.RED;
    private static final Color[] COLOR_OUT = new Color[]{Color.CYAN.darker(), Color.MAGENTA};
    private static final Attribute<Integer> SELECTOR_BITS_ATTR = Attributes.forIntegerRange((String)"Selector bits", (int)1, (int)6);

    public Bounds getOffsetBounds(AttributeSet attrs) {
        int size = 1 << (Integer)attrs.getValue(SELECTOR_BITS_ATTR);
        return Bounds.create((int)-80, (int)-50, (int)80, (int)(90 + (size * 11 + 9) / 10 * 10));
    }

    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        RegisterData data = (RegisterData)painter.getData();
        int width = ((BitWidth)painter.getAttributeValue(StdAttr.WIDTH)).getWidth();
        int selectorWidth = (Integer)painter.getAttributeValue(SELECTOR_BITS_ATTR);
        int fileSize = 1 << selectorWidth;
        painter.drawBounds();
        g.setColor(COLOR_IN);
        painter.drawPort(0, "in", Direction.SOUTH);
        painter.drawPort(11, "rst", Direction.WEST);
        g.setColor(COLOR_OUT[0]);
        painter.drawPort(PORT_OUT[0], "out1", Direction.NORTH);
        g.setColor(COLOR_OUT[1]);
        painter.drawPort(PORT_OUT[1], "out2", Direction.NORTH);
        g.setColor(Color.BLACK);
        painter.drawClock(3, Direction.EAST);
        painter.drawPort(4, "is", Direction.EAST);
        painter.drawPort(PORT_OS[0], "os1", Direction.EAST);
        painter.drawPort(PORT_OS[1], "os2", Direction.EAST);
        painter.drawPort(PORT_ON[0], "on1", Direction.WEST);
        painter.drawPort(PORT_ON[1], "on2", Direction.WEST);
        painter.drawPort(PORT_OZ[0], "oz1", Direction.WEST);
        painter.drawPort(PORT_OZ[1], "oz2", Direction.WEST);
        if (painter.getShowState()) {
            int x = bds.getX() + 40;
            int y = bds.getY() + 63;
            g.setColor(Color.GRAY);
            g.drawRect(x - 30, y + 1, 60, 11 * fileSize + 2);
            g.setColor(Color.BLACK);
            int i = 0;
            while (i < fileSize) {
                int val = data == null ? 0 : data.getValue(i);
                String str = String.valueOf(StringUtil.toHexString((int)selectorWidth, (int)i)) + ": " + (val >= 0 ? StringUtil.toHexString((int)width, (int)val) : "ERR");
                GraphicsUtil.drawText((Graphics)g, (String)str, (int)x, (int)(y + 11 * i), (int)0, (int)-1);
                ++i;
            }
            Value inSel = painter.getPort(4);
            if (inSel.isFullyDefined()) {
                g.setColor(COLOR_IN);
                g.fillRect(x - 33, y + 2 + 11 * inSel.toIntValue(), 2, 11);
            }
            int i2 = 0;
            while (i2 < 2) {
                Value outSel = painter.getPort(PORT_OS[i2]);
                if (outSel.isFullyDefined()) {
                    g.setColor(COLOR_OUT[i2]);
                    g.fillRect(x + 32 + 3 * i2, y + 2 + 11 * outSel.toIntValue(), 2, 11);
                }
                ++i2;
            }
        }
    }

    public void propagate(InstanceState state) {
        int index;
        int i;
        Value rst;
        BitWidth dataWidth = (BitWidth)state.getAttributeValue(StdAttr.WIDTH);
        int selectorWidth = (Integer)state.getAttributeValue(SELECTOR_BITS_ATTR);
        int fileSize = 1 << selectorWidth;
        RegisterData data = (RegisterData)state.getData();
        if (data == null) {
            data = new RegisterData(fileSize);
            state.setData((InstanceData)data);
        }
        if (data.getSize() != fileSize) {
            data.resize(fileSize);
        }
        if ((rst = state.getPort(11)).isFullyDefined() && rst.toIntValue() == 0) {
            i = 0;
            while (i < fileSize) {
                data.setValue(i, 0);
                ++i;
            }
        } else {
            boolean triggered = data.updateClock(state.getPort(3), StdAttr.TRIGGER);
            if (triggered) {
                Value in = state.getPort(0);
                Value inSel = state.getPort(4);
                if (inSel.isFullyDefined()) {
                    index = inSel.toIntValue();
                    if (in.isFullyDefined()) {
                        data.setValue(index, in.toIntValue());
                    } else {
                        data.setValue(index, Integer.MIN_VALUE);
                    }
                } else {
                    int i2 = 0;
                    while (i2 < fileSize) {
                        data.setValue(i2, Integer.MIN_VALUE);
                        ++i2;
                    }
                }
            }
        }
        i = 0;
        while (i < 2) {
            Value outSel = state.getPort(PORT_OS[i]);
            boolean undef = false;
            if (outSel.isFullyDefined()) {
                index = outSel.toIntValue();
                int outVal = data.getValue(index);
                if (outVal == Integer.MIN_VALUE) {
                    undef = true;
                } else {
                    state.setPort(PORT_OUT[i], Value.createKnown((BitWidth)dataWidth, (int)outVal), 8);
                    state.setPort(PORT_ON[i], (outVal >> dataWidth.getWidth() - 1 & 1) != 0 ? Value.TRUE : Value.FALSE, 8);
                    state.setPort(PORT_OZ[i], outVal == 0 ? Value.TRUE : Value.FALSE, 8);
                }
            } else {
                undef = true;
            }
            if (undef) {
                state.setPort(PORT_OUT[i], Value.UNKNOWN, 8);
                state.setPort(PORT_ON[i], Value.UNKNOWN, 8);
                state.setPort(PORT_OZ[i], Value.UNKNOWN, 8);
            }
            ++i;
        }
    }

    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == SELECTOR_BITS_ATTR) {
            instance.recomputeBounds();
            this.computePorts(instance);
        }
    }

    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.computePorts(instance);
    }

    private void computePorts(Instance instance) {
        int selectorWidth = (Integer)instance.getAttributeValue(SELECTOR_BITS_ATTR);
        Bounds bounds = instance.getBounds();
        int bottom = bounds.getHeight() - 50;
        instance.setPorts(new Port[]{new Port(-40, bottom, "input", StdAttr.WIDTH), new Port(-60, -50, "output", StdAttr.WIDTH), new Port(-20, -50, "output", StdAttr.WIDTH), new Port(-80, bottom - 10, "input", 1), new Port(-80, bottom - 20, "input", selectorWidth), new Port(-80, -30, "input", selectorWidth), new Port(-80, -20, "input", selectorWidth), new Port(0, -30, "output", 1), new Port(0, -20, "output", 1), new Port(0, -10, "output", 1), new Port(0, 0, "output", 1), new Port(0, bottom - 20, "input", 1)});
    }

    public RegisterFile() {
        super("Register File");
        this.setAttributes(new Attribute[]{StdAttr.TRIGGER, StdAttr.WIDTH, SELECTOR_BITS_ATTR}, new Object[]{StdAttr.TRIG_RISING, BitWidth.create((int)8), 3});
    }
}

