/*
 * Decompiled with CFR 0.152.
 */
package fr.supelec.ese1010.registers;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.memory.RegisterLogger;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import fr.supelec.ese1010.registers.RegisterData;
import fr.supelec.ese1010.registers.RegisterPoker;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class IncRegister
extends InstanceFactory {
    private static final Bounds OFFSET_BOUNDS = Bounds.create((int)-30, (int)-20, (int)60, (int)40);
    private static final int DELAY = 8;
    private static final int OUT = 0;
    private static final int IN = 1;
    private static final int CK = 2;
    private static final int CLR = 3;
    private static final int COMMAND = 4;

    public IncRegister() {
        super("Inc Register");
        this.setAttributes(new Attribute[]{StdAttr.WIDTH}, new Object[]{BitWidth.create((int)8)});
        this.setOffsetBounds(OFFSET_BOUNDS);
        this.setPorts(new Port[]{new Port(30, 0, "output", StdAttr.WIDTH), new Port(-30, 0, "input", StdAttr.WIDTH), new Port(-20, 20, "input", 1), new Port(0, 20, "input", 1), new Port(20, 20, "input", 1)});
        this.setInstancePoker(RegisterPoker.class);
        this.setInstanceLogger(RegisterLogger.class);
    }

    public void paintIcon(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Font old = g.getFont();
        g.setFont(old.deriveFont(9.0f));
        GraphicsUtil.drawCenteredText((Graphics)g, (String)"R++", (int)10, (int)9);
        g.setFont(old);
        g.drawRect(0, 4, 19, 12);
        int dx = 2;
        while (dx < 20) {
            g.drawLine(dx, 2, dx, 4);
            g.drawLine(dx, 16, dx, 18);
            dx += 5;
        }
    }

    public void propagate(InstanceState state) {
        RegisterData data = (RegisterData)state.getData();
        if (data == null) {
            data = new RegisterData();
            state.setData((InstanceData)data);
        }
        BitWidth dataWidth = (BitWidth)state.getAttributeValue(StdAttr.WIDTH);
        Object triggerType = state.getAttributeValue(StdAttr.TRIGGER);
        boolean triggered = data.updateClock(state.getPort(2), triggerType);
        if (state.getPort(3) == Value.TRUE) {
            data.setValue(0);
        } else if (triggered) {
            if (state.getPort(4) == Value.FALSE) {
                data.setValue(data.getValue() + 1);
            } else {
                Value in = state.getPort(1);
                if (in.isFullyDefined()) {
                    data.setValue(in.toIntValue());
                } else {
                    data.setValue(Integer.MIN_VALUE);
                }
            }
        }
        int outValue = data.getValue();
        if (outValue != Integer.MIN_VALUE) {
            state.setPort(0, Value.createKnown((BitWidth)dataWidth, (int)outValue), 8);
        } else {
            state.setPort(0, Value.UNKNOWN, 8);
        }
    }

    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        RegisterData state = (RegisterData)painter.getData();
        int width = ((BitWidth)painter.getAttributeValue(StdAttr.WIDTH)).getWidth();
        painter.drawBounds();
        if (width <= 16 || !painter.getShowState()) {
            painter.drawPort(1, "D", Direction.EAST);
            painter.drawPort(0, "Q", Direction.WEST);
        } else {
            painter.drawPort(1);
            painter.drawPort(0);
        }
        g.setColor(Color.GRAY);
        painter.drawPort(3, "clr", Direction.SOUTH);
        g.setColor(Color.BLACK);
        painter.drawClock(2, Direction.NORTH);
        painter.drawPort(4, "c", Direction.SOUTH);
        if (painter.getShowState()) {
            String str;
            int val = state == null ? 0 : state.getValue();
            String string = str = val != Integer.MIN_VALUE ? StringUtil.toHexString((int)width, (int)val) : "ERR";
            if (str.length() <= 4) {
                GraphicsUtil.drawText((Graphics)g, (String)str, (int)(bds.getX() + 30), (int)(bds.getY() + 4), (int)0, (int)-1);
            } else {
                int split = str.length() - 4;
                GraphicsUtil.drawText((Graphics)g, (String)str.substring(0, split), (int)(bds.getX() + 30), (int)(bds.getY() + 3), (int)0, (int)-1);
                GraphicsUtil.drawText((Graphics)g, (String)str.substring(split), (int)(bds.getX() + 30), (int)(bds.getY() + 15), (int)0, (int)-1);
            }
        }
    }
}

